<?php
/**
 * OnGetSellingUnitVpeEventListener.php 2020-3-26
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */
declare(strict_types=1);
namespace Gambio\Shop\Product\SellingUnitVpe\Listeners;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitVpeEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Vpe;

class OnGetSellingUnitVpeEventListener
{
    /**
     * @param OnGetSellingUnitVpeEventInterface $event
     */
    public function __invoke(OnGetSellingUnitVpeEventInterface $event)
    {
        if ($event->product()->getVpeStatus() && $event->product()->getVpeValue() && $event->product()->getVpeId()) {
    
            $vpeValue = $event->product()->getVpeValue();
            $vpeId    = $event->product()->getVpeId();
            $vpe      = $this->createVpe($vpeValue, $vpeId);
            
            $event->setVpe($vpe);
        }
    }

    /**
     * @param float $vpeValue
     * @param int $vpeId
     * @return Vpe
     */
    protected function createVpe(float $vpeValue, int $vpeId): Vpe
    {
        $name = xtc_get_vpe_name($vpeId);
        return new Vpe($vpeId, $name, $vpeValue);
    }

}